# Project to build a script that can be called to automatically generate wireguard configurations and add peer entries to a wireguard 'server'
import os # File handling!
import json # Why use anything else?
import subprocess # Need this to call 
import sys # Need to import a module to terminate the app.  Silly.
import random
import hashlib

def GetMD5(aFileName):
    if not os.path.exists(aFileName):
        raise ValueError('Error: No such file or directory (GetMD5)')
    else:
        oMD5 = hashlib.md5() #md5 is no good for security, but this is not about security.
        with open(aFileName, 'rb') as target:
            while chunk := target.read(8192):
                oMD5.update(chunk)
        return oMD5.hexdigest()
def IPToInt(aStrIn): #Takes an IPv4 address and converts it to an integer.
    sIP = aStrIn.split('.')
    bErr = False
    if len(sIP) != 4: bErr = True
    if not bErr:
        for n in range(4):
            if isinstance(sIP[n], int) or int(sIP[n]) < 0 or int(sIP[n]) > 255: 
                bErr = True
                break
            sIP[n] = format(int(sIP[n]), 'b')
    if bErr: raise TypeError('TypeError in IPToInt: parameter is not a valid TCP/IPv4 address.')
    else: iReturn = int(sIP[0].rjust(8,'0') + sIP[1].rjust(8,'0') + sIP[2].rjust(8,'0') + sIP[3].rjust(8,'0'), 2)
    return iReturn
def IntToIP(aIntIn): # Takes an integer and converts it to an IP address
    if not isinstance(aIntIn, int): 
        raise TypeError('Error: TypeError in IntToIP: parameter is not int!')
    if aIntIn < 0 or aIntIn > 2**32-1:
        raise ValueError('Error: Index out of bounds: parameter in IntToIP is too large or small')
    sIP = format(aIntIn,'b')
    if len(sIP) < 32:
        sIP = sIP.rjust(32,'0')
    sWIP = [
        str(int(sIP[0:8], 2)),
        str(int(sIP[8:16], 2)),
        str(int(sIP[16:24], 2)),
        str(int(sIP[24:32], 2))
    ]
    sIP = sWIP[0] + '.' + sWIP[1] + '.' + sWIP[2] + '.' + sWIP[3]
    return sIP
def GenIPRange(aLB,aUB): # Generates ./addresses which contains all the valid IP addresses in the configured range
    iLower = IPToInt(aLB)
    iUpper = IPToInt(aUB)
    iOut = iLower
    if iLower > iUpper: raise ValueError('Error: Lower bound is greater than upper bound (GenIPRange()).')
    if (iUpper - iLower) >= (2**20) + 1:
        if input('The IP range chosen is very large.  Construction of tunnels may take a long time ' +
                 'and consume a significant amount of system resources.  Do you wish to proceed? ') != 'y':
            sys.exit()
    while iUpper >= iOut:
        if iUpper == iOut: 
            yield IntToIP(iOut) + '\n'
            break
        while int(IntToIP(iOut).split('.')[3]) == 0 or int(IntToIP(iOut).split('.')[3]) == 255:
            iOut += 1
        yield IntToIP(iOut) + '\n'
        iOut += 1
def GetIP(pFileName):
    sOut = ''
    if not os.path.exists(pFileName):
        raise ValueError('Error: GetIP(): No such file or directory')
    iFileLength = 0
    with open(pFileName,'r') as file:
        for n in file:
            iFileLength += 1
    iLine = random.randint(0,iFileLength - 1)
    if os.path.exists(pFileName + '.tmp'):
        os.remove(pFileName + '.tmp')
    with open(pFileName + '.tmp','w') as temp:
        with open (pFileName,'r') as file:
            for n in range(iFileLength):
                if n != iLine:
                    temp.write(file.readline())
                else: 
                    sOut = file.readline()
    sOld = pFileName
    sNew = pFileName + '.tmp'
    if os.path.exists(sOld + '.old'): os.remove(sOld + '.old') #Debug line, comment or remove for production
    os.rename(sOld, sOld + '.old') #Debug line, comment or remove for production
    # os.remove(sOld) # Uncomment me for production, intended to replace line above
    os.rename(sNew, sOld)
    return sOut.strip()
def output(aName, # N
           aHPriKey, 
           aHIP, 
           aHDNS, 
           aPPubKey, 
           aPSK, 
           aPIP, 
           aPPort, 
           aAllIPs=None, 
           aHPort=None
           ):  # This function composites the wireguard configuration file. 
    vHP = None
    vAC = None
    try:
        vName = str(aName).strip()
        vHK = str(aHPriKey).strip()
        vHA = str(aHIP).strip()
        vHD = str(aHDNS).strip()
        vPK = str(aPPubKey).strip()
        vPSK = str(aPSK).strip() # This is part of the Peer section
        vPA = str(aPIP).strip()
        vPP = str(aPPort).strip()
        if aAllIPs != None: vAC = str(aAllIPs).strip()
        if aHPort != None: vHP = str(aHPort).strip()
    except TypeError:
        print('Oops.  TypeError in wireguard.py.output()  How the hell did you manage that?')
        return None 
    with open('./' + vName + '.conf', 'w') as conf: # Heeey.  We're actually constructing the peer interface!
        conf.write('[INTERFACE]\n')
        conf.write('# Name: ' + vName + '\n')
        conf.write('PrivateKey = ' + vHK + '\n')
        conf.write('Address = ' + vHA + '\n')
        if vHP: conf.write('ListenPort = ' + vHP + '\n')
        conf.write('DNS = ' + vHD + '\n')
        conf.write('\n')
        conf.write('[PEER]\n')
        conf.write('PublicKey = ' + vPK + '\n')
        conf.write('PresharedKey = ' + vPSK + '\n')
        if vAC: conf.write('AllowedIPs = ' + vAC + '\n')
        else: conf.write('AllowedIPs = 0.0.0.0/0\n')
        conf.write('Endpoint = ' + vPA + ':' + vPP + '\n')
        conf.write('PersistentKeepalive = 32')
    return './' + vName + '.conf'
def AddPeerMikrotik(aTName, # Tunnel Name
                    aSSHPORT, # SSH port / C_CONSTANTS['C_WG_SSHPORT']
                    aSSHID, # Credential file for the remote host / C_CONSTANTS['C_WG_REMOTE_ID']
                    aSSHUN, # Username for SSH / C_CONSTANTS['C_WG_UN']
                    aWGNode, # The primary wireguard node's address / C_CONSTANTS['WG_ADDRESS']
                    aHIP, # New peer's WGIF IP address 
                    aHPubKey, # New peer's public key
                    aPSK, # Pre-shared keeeeey
                    aIFNAME, #Wireguard interface name, if necessary
                    aHPort=None # Peer WG Listen Port, if necessary
                    ): # Adds a new peer to a Mikrotik primary WireGuard node.
    sName = 'comment=\\"Added by AutoTun v0.5: Wireguard Tunnel: ' + str(aTName).strip() + '\\" '
    sPort = str(aSSHPORT).strip()
    sID = str(aSSHID).strip() 
    sUser = str(aSSHUN).strip()
    sAddr = str(aWGNode).strip()
    sIF = 'interface=\\"' + str(aIFNAME).strip() + '\\" '
    sIP = 'allowed-address=' + str(aHIP).strip() + '/32 '
    sPub = 'public-key=\\"' + str(aHPubKey).strip() + '\\" '
    sPSK = 'preshared-key=\\"' + str(aPSK).strip() + '\\" '
    sRun = 'ssh -p ' + sPort + ' -i ' + sID + ' ' + sUser + '@' + sAddr + ' "/interface wireguard peers add ' + sIF + sIP + sPub + sPSK + sName + 'persistent-keepalive=24"'
    if aHPort != None: sRun = sRun + 'endpoint-port=' + str(aHPort).strip()
    print(sRun)
    subprocess.run(sRun)
    # So need: 
    # - SSH port - C_WG_SSHPORT
    # - SSH identity - C_WG_REMOTE_ID
    # - WG Node Username - C_WG_UN
    # - WG Node Address - C_WG_ADDRESS
    # - interface= - C_WG_IFNAME
    # - allowed-address - aHIP
    # - public-key - vPub
    # - preshared-key - vPSK
    # - comment=""

    return True
def AddPeer(aType, # The WireGuard node's type.  RouterOS, SonicWall, OPNSense, etc.  Currently only RouterOS is valid / C_CONSTANTS['C_I_PLATFORM']
            aTName, # Tunnel Name / vName
            aSSHPORT, # SSH port / C_CONSTANTS['C_WG_SSHPORT']
            aSSHID, # Credential file for the remote host / C_CONSTANTS['C_WG_REMOTE_ID']
            aSSHUN, # Username for SSH / C_CONSTANTS['C_WG_UN']
            aWGNode, # The primary wireguard node's address / C_CONSTANTS['WG_ADDRESS']
            aHIP, # New peer's WGIF IP address 
            aHPubKey, # New peer's public key
            aPSK, # Pre-shared keeeeey
            aIFNAME=None, #Wireguard interface name, if necessary
            aHPort=None # Peer WG Listen Port, if necessary
            ): #Automatically adds a new peer to the primary WireGuard node.
    match aType:
        case 'ROUTEROS7':
            return AddPeerMikrotik(aTName,aSSHPORT,aSSHID,aSSHUN,aWGNode,aHIP,aHPubKey,aPSK,aIFNAME,aHPort)
        case _:
            raise ValueError('Error: Unsupported node type in AddPeer()')

vName = input('Tunnel name: ').strip()
vPri = subprocess.run("wg genkey",capture_output=True,text=True).stdout
vPub = subprocess.run("wg pubkey", input=vPri, capture_output=True, text=True).stdout
vPSK = subprocess.run("wg genpsk",capture_output=True,text=True).stdout
# Note!  Keygen INCLUDES newlines.  / This doesn't matter so much since .strip() is now called standard.
C_CONSTANTS = { # CONVENTIONS: 'C_' = 'Constant', 'CFG_' = Config file item, 'I_' = Internal script switches, 'WG_' = Pertaining to the WG remote node
    'C_CFG_ENDPOINT_ADDR':'vpn.example.org', 
    'C_CFG_DNS':'8.8.8.8, 8.8.4.4', 
    'C_CFG_ENDPOINT_PORT':'12345', 
    'C_CFG_ENDPOINT_PUBKEY':'ThisIsAnExamplePublicKeyWhichIsABase64Value=\n', 
    'C_I_IPADDR_LB':'192.168.128.1', 
    'C_I_IPADDR_UB':'192.168.255.254', 
    'C_CFG_ALLIPS':'0.0.0.0/0',
    'C_I_PLATFORM':'ROUTEROS7', # C_PLATFORM is the platform of the primary Wireguard node.  Current allowed values are 'ROUTEROS7' - MikroTik's routerOS v7.x
    'C_WG_REMOTE_ID':'./id_rsa', #Credentials file for the WG node.  DO NOT STORE CREDENTIALS IN CONFIG.JSON!!!!
    'C_WG_ADDRESS':'172.16.0.1', # Wireguard endpoint address
    'C_WG_IFNAME':'wg.sadler.family', # Wireguard interface name.  Crucial for Mikrotik impletmentations
    'C_WG_SSHPORT':'22', #SSH port for the remote server
    'C_WG_UN':'' # Username for the remote WG server.
    }

if os.path.exists('./' + vName + '.conf'):
    print('Error: A Tunnel of that name already exists.  Please download ' + vName + '.conf')
    sys.exit()

if os.path.exists('./config.json'):
    if os.path.exists('./config.md5'):
        sMD5 = ''
        with open('./config.md5') as hash:
            sMD5 = hash.readline()
        if sMD5 != GetMD5('./config.json'):
            raise ValueError('config.json failed hash validation.')
        with open('./config.json', 'r') as cfg:
            C_CONSTANTS = json.loads(cfg.read())
            print(C_CONSTANTS) # This is ultimately where json validation will happen.
    else: 
        raise ValueError('config.json failed hash validation.')
else:
    with open('./config.json', 'a') as cfg:
        for key in C_CONSTANTS:
            sIn = input('Please enter the value for the Wireguard ' + key + ' [' + C_CONSTANTS[key] + ']: ')
            if sIn != '':
                C_CONSTANTS[key] = sIn
            pass # sanity check code goes here.  Actually...  What if I don't want to sanity check inputs?
        cfg.writelines(json.dumps(C_CONSTANTS))
    if os.path.exists('./config.md5'):
        os.remove('./config.md5') # Log here later.
    sMD5 = GetMD5('./config.json')
    with open('./config.md5', 'w') as hash:
        hash.write(sMD5)

if not os.path.exists('./addresses'):
    with open('./addresses', 'w') as vAddlst:
        vAddlst.writelines(GenIPRange(C_CONSTANTS['C_I_IPADDR_LB'],C_CONSTANTS['C_I_IPADDR_UB']))

vIP = GetIP('./addresses')

vFileOut = output(vName,
                  vPri,
                  vIP,
                  C_CONSTANTS['C_CFG_DNS'],
                  C_CONSTANTS['C_CFG_ENDPOINT_PUBKEY'],
                  vPSK,
                  C_CONSTANTS['C_CFG_ENDPOINT_ADDR'],
                  C_CONSTANTS['C_CFG_ENDPOINT_PORT']
                  )

AddPeer(C_CONSTANTS['C_I_PLATFORM'],
        vName,
        C_CONSTANTS['C_WG_SSHPORT'],
        C_CONSTANTS['C_WG_REMOTE_ID'],
        C_CONSTANTS['C_WG_UN'],
        C_CONSTANTS['C_WG_ADDRESS'],
        vIP,
        vPub,
        vPSK,
        C_CONSTANTS['C_WG_IFNAME']
        )